global project "C:\Users\jwolfers\Documents\Justin@Wharton\Trust in Public Institutions\AER Archive"
cd "$project"
log using "Log files.txt", text replace

* Compile state unemployment rates
cd "State economic conditions"
do "State economic conditions.do"
cd "$project"

* Compile and clean the Gallup trust data
cd "Gallup trust"
do "Gallup_trust_compile.do"
do "Gallup_trust_clean.do"
cd "$project"

* Compile and clean the Gallup honesty data
cd "Gallup honesty"
do "gallup_honesty_compile.do"
do "Gallup_honesty_clean.do"
cd "$project"

* Compile and clean the GSS: Note the state identifiers can't be shared by me, so the code won't work perfectly
cd "GSS"
do "GSS_clean.do"
cd "$project"

* Compile and clean the Gallup World Poll: These data are entirely proprietary
cd "Gallup World Poll"
do "Clean_Gallup.do"
cd "$project"

*** Figure 1: Confidence in institutions--Time series plot
use "Gallup trust\Trust_gallup", clear
for var banks-tvnews: gen X_high=(X>3) if X<.
gen n=1
replace year=year(dt) if year==.
collapse (mean) *_high (sum) n [aw=wt], by(year)
append using "..\National time series\Unemployment rate.dta"
collapse (mean) *_high ur (sum) n , by(year)
replace ur_usa=ur_usa/100
keep if year>=1972

* Add in recession data
append using "..\National time series\NBER Recessions", keep(recession date)
rename date nber_date 
gen zero=0 if nber_date~=.
drop if nber_date<1972

replace recession=.75 if recession>0

twoway ///
	(rarea recession zero nber_date, sort lcolor(bg) fcolor(gs12)) ///
	(line congress year, sort lpattern(dash) lcolor(navy) lwidth(medthick)) ///
	(line supcourt year, sort lpattern(longdash) lcolor(orange)) ///
	(line banks year, sort lpattern(solid) lcolor(cranberry) lwidth(medthick)) ///
	(line newspapers year, sort lpattern(shortdash_dot)) ///
	(line bigbus year, sort lpattern(shortdash) lcolor(green) lwidth(medthick)) ///
	, ///
	legend( ///
		title("Proportion expressing quite a lot of confidence in:") ///
		order(4 "Banks" 3 "Supreme Court" 5 "Newspapers" 2 "Congress" 6 "Big business") ///
		size(large) symxsize(*.5) keygap(*.05) bmargin(none) ///
		rows(1) ///
		ring(0) pos(12) ///
	) ///
	xlabel(,nolabel tposition(inside)) xtitle("")  ///
	ylabel(0(.1)0.75, angle(horizontal) format(%9.2f)) ytitle("") ///
	xsize(10) ysize(7.5) ///
	name(trust, replace)

replace recession=.1 if recession>0
twoway ///
	(rarea recession zero nber_date, sort lcolor(bg) fcolor(gs12)) ///
	(line ur year, sort lcolor(black)) ///
	, ///
	title("Unemployment Rate", ring(0) pos(12)) ///
	ylabel(0.0(.02).1, angle(horizontal) format(%9.2f)) ytitle("") ///
	xtitle("") xlabel(1970(10)2010, tpos(inside) labsize(medlarge)) ///
	note("Shaded areas denote NBER-designated recessions.", ring(0) pos(7) size(medium)) ///
	legend(off) ///
	fysize(30) ///
	name(ur, replace)

graph combine trust ur, ///
	rows(2)  imargin(none) ///
	xsize(10) ysize(7.5)
	
graph export "$project\fig1.eps", replace

* Table 1: US Time Series
* Table 1, Panel A: Gallup Trust
use "$project\Gallup trust\Trust_gallup", clear
for var banks-tvnews: gen X_high=(X>3) if X<.
gen n=1
replace year=year(dt) if year==.
collapse (mean) *_high (sum) n [aw=wt], by(year)
append using "$project\National time series\Unemployment rate.dta"
collapse (mean) *_high ur (sum) n , by(year)
replace ur_usa=ur_usa/100
keep if year>=1972
tsset year
for X in var congress banks bigbus supcourt newspapers: newey X ur year, lag(3) force \ newey X ur year if year<2007, lag(3) force \ table year if year==2007 | year==2010, c(m X)

* Table 1, Panel B
use "$project\GSS\Trust_GSS", clear
for var confinan-conarmy: gen X_high=(X==3) if X<.
gen n=1
collapse (mean) *_high (sum) n [aw=wt], by(year)
append using "$project\National time series\Unemployment rate.dta"
collapse (mean) *_high ur (sum) n , by(year)
replace ur_usa=ur_usa/100
keep if year>=1972
tsset year
for X in var conlegis confinan conbus conjudge conpress: newey X ur year, lag(3) force 

* Table 1, Panel C
use "$project\Gallup honesty\Honesty_gallup", clear
keep st dt ur advertisers-unionleaders wt
for var advertisers-unionleaders: gen X_high=(X>=4) if X<.
gen n=1
gen year=year(dt) 
collapse (mean) *_high (sum) n [aw=wt], by(year)
append using "$project\National time series\Unemployment rate.dta"
collapse (mean) *_high ur (sum) n , by(year)
replace ur_usa=ur_usa/100
keep if year>=1972
tsset year
for X in var congressmen bankers busexecs lawyers journalists: newey X ur year, lag(3) force \ newey X ur year if year<2007, lag(3) force \ table year if year==2007 | year==2010, c(m X)
	
* Note: The Gallup World Poll Data are proprietary, so I can't share them.	
* Figure 2: GWP first differences
use "$project\Proprietary\Gallup_work", clear 
gen n=1
gen after=(year>=2009)
replace after=. if year==2008
foreach v of varlist conf_* {
	local l`v': variable label `v'
	di "`l`v''"
	local l`v'=substr("`l`v''", strpos("`l`v''", "in")+2,25)
	di "`l`v''"
}
collapse (mean) conf_* ur oecd (sum) n [aw=wt], by(cty after)
foreach v of varlist conf_* {
	label var `v' "`l`v''"
	replace `v'=`v'*100
}
la var conf_media "The Media"
egen ctyid=group(cty)
tsset ctyid after
gen dur=d.ur
foreach v of varlist conf* {
	local l: variable label `v'
	lowess d.`v' d.ur, nograph gen(low_`v')
	reg d.`v' d.ur
	local b=string(_b[d.ur],"%3.2f")
	local se=string(_se[d.ur], "%3.2f")
	local c=string(_b[_cons],"%3.2f")
	correl d.`v' d.ur
	local rho=string(r(rho),"%3.2f")
	twoway ///
		(scatter d.`v' d.ur if oecd==1, mcolor(black) msymbol(square) mlabel(cty) mlabcolor(black) mlabpos(6)) ///
		(scatter d.`v' d.ur if oecd==0, mcolor(black) msymbol(circle_hollow) mlabel(cty) mlabcolor(black) mlabpos(6)) ///
		(line low_`v' dur,  sort lpattern(dot) lcolor(cranberry)) ///
		(lfit d.`v' d.ur, lcolor(gray) lpattern(dash)) ///
		if d.`v'!=., ///
		legend(off) ///
		title("`l'", ring(0) pos(12)) ///
		subtitle(" " "Correlation = `rho'; Slope = `b' [se=`se']" , ring(0) pos(12)) ///
		xlabel(-4(2)12) ///
		ylabel(-40(10)40, angle(horizontal) format(%9.0f)) ///
		xtitle("") ytitle("") ///
		xsize(10) ysize(7.5) name(`v', replace)
	
	drop low_`v'
}	

graph combine conf_govt conf_finance conf_judicial conf_media, ///
	rows(2) imargin(tiny) ///
	l1title("Change in Confidence (percentage points)") ///
	b1title("Change in Unemployment rate (percentage points)") ///
	xsize(10) ysize(7.5) name(changes, replace)
graph export "$project\fig2.eps", replace

	
* Table 2: Gallup World Poll
use "$project\Proprietary\Gallup_work", clear
* Number of observations
egen nonmiss=rownonmiss(conf*)
qui tab cty if nonmiss~=. 
return list 
qui tab cty if ur~=. 
return list
qui tab cty if nonmiss~=. & ur~=. 
return list

* Panel A: Means
for var conf_*: summ X if ur~=. [aw=wt] \ qui tab cty if ur~=. & X~=. \ return list

* Panel B: Probit regressions
replace ur=ur/100
egen ctyid=group(cty)
for X in var sex age marital urban educ: replace X=101 if X==.
for var conf_*: qui probit X ur i.sex i.age i.marital i.urbanrural i.educ i.ctyid i.year [pw=wt], cluster(cty) \ margins, dydx(ur) 

* Panel C: OECD only
for var conf_*:	qui probit X ur i.sex i.age i.marital i.urbanrural i.educ i.ctyid i.year [pw=wt] if oecd==1, cluster(cty) \ margins, dydx(ur)



*Table 3: Cross-state analysis
* Table 3, Panel A: Gallup Trust
use "$project\Gallup trust\Trust_gallup", clear
egen surveyid=group(dt)
for X in var age sex race3 educ: replace X=999 if X==.
for var congress banks bigbus supcourt newspapers: ///
	gen X_high=(X>3) if X<. \ ///
	qui probit X_high ur i.stid i.year i.age i.sex i.race3 i.educ [pw=wt], cluster(st) nolog \ ///
	margins, dydx(ur) 

* Table 3, Panel B /* This needs access to the proprietary state codes*/
use "$project\Proprietary\Trust_GSS", clear
egen stid=group(st)
for X in var age sex race ed: replace X=999 if X==.
for var conlegis confinan conbus conjudge conpress: ///
	gen X_high=(X==3) if X<. \ ///
	qui probit X_high ur i.stid i.year i.age i.sex i.race i.edgroup [pw=wt], cluster(st) nolog \ ///
	margins, dydx(ur)

* Table 3, Panel C
use "$project\Gallup honesty\Honesty_gallup", clear
for X in var age sex race3 ed: replace X=999 if X==.
for var congressmen bankers busexecs lawyers journalists: ///
	gen X_high=(X>=4) if X<. \ ///
	qui probit X_high ur i.stid i.year i.age i.sex i.race3 i.educ [pw=wt], cluster(st) nolog \ ///
	margins, dydx(ur)
	
log close
	
	
